#include <bits/stdc++.h>
using namespace std;

using ll = long long;

const int MAXN = 300005;

ll a[MAXN];
int n;
int mnPos = 1;

ll vals[MAXN]; //dynamically updated, vals[i] = best res if element ends at i

int st[4 * MAXN];
int lazy[4 * MAXN];

void build(int id, int l, int r){
    if(l == r){
        st[id] = vals[l];
        return;
    }

    int mid = (l + r) / 2;
    build(id * 2 + 1, l, mid);
    build(id * 2 + 2, mid + 1, r);
    st[id] = max(st[id * 2 + 1], st[id * 2 + 2]);
    lazy[id] = -1;
}

void updNode(int id, int x){
    if(x != -1){
        lazy[id] = x;
        st[id] = x;
    }
}

void shift(int id, int l, int r){
    int mid = (l + r) / 2;
    updNode(id * 2 + 1, lazy[id]);
    updNode(id * 2 + 2, lazy[id]);
    lazy[id] = -1;
}

void updateRange(int x, int y, int v, int id, int l, int r){
    if(x > r || y < l)
        return;
    if(x <= l && r <= y){
        updNode(id, v);
        return;
    }

    shift(id, l, r);
    int mid = (l + r) / 2;
    updateRange(x, y, v, id * 2 + 1, l, mid);
    updateRange(x, y, v, id * 2 + 2, mid + 1, r);
    st[id] = max(st[id * 2 + 1], st[id * 2 + 2]);
}

void update(int x, int id, int l, int r){
    if(x > r || x < l)
        return;
    if(l == r){
        st[id] = st[id] + 1;
        return;
    }

    shift(id, l, r);
    int mid = (l + r) / 2;
    update(x, id * 2 + 1, l, mid);
    update(x, id * 2 + 2, mid + 1, r);
    st[id] = max(st[id * 2 + 1], st[id * 2 + 2]);
}

int getmx(int x, int y, int id, int l, int r){
    if(x > r || y < l)
        return INT_MIN;
    if(x <= l && r <= y)
        return st[id];

    shift(id, l, r);
    int mid = (l + r) / 2;
    int v1 = getmx(x, y, id * 2 + 1, l, mid);
    int v2 = getmx(x, y, id * 2 + 2, mid + 1, r);
    return max(v1, v2);
}

int Slamke(int N, int* A, int M, int* T, int* X, int* Y){
    n = N;
    for(int i = 1; i <= n; ++i){
        a[i] = A[i];
    }
    for(int i = 1; i <= n; ++i){
        if(a[mnPos] > a[i]){
            mnPos = i;
        }
    }

    for(int i = 1; i <= n; ++i){
        vals[i] = INT_MIN;
        if(i == mnPos){
            vals[i] = 0;
        }
    }

    lazy[0] = -1;
    build(0, 1, n);

    for(int t = 1; t <= M; ++t){
        if(T[t] == 1){
            int mxval = getmx(X[t], Y[t], 0, 1, n);
            updateRange(X[t], Y[t], mxval, 0, 1, n);
        }else{
            update(X[t], 0, 1, n); // +1
        }
    }

    int res = getmx(1, n, 0, 1, n);
    return res;
}


/*
6
3 1 4 6 5 2
4
1 2 4
2 5 0
1 4 6
2 5 0


4
4 3 2 1
4
1 1 4
2 1 0
2 1 0
2 3 0
*/